#! /usr/bin/env julia


# -----------------------------------------------------------------------------------------
library(data.table)
library(tidyr)
# -----------------------------------------------------------------------------------------


# -----------------------------------------------------------------------------------------
dt0 = fread("./output/FX_daily.csv")


# if there are row names...
dt0 = data.frame(dt0[, -"V1"])


N <- ncol(dt0)

## Adjusting base = denominator:
dt0[, 2:N] <- 1/dt0[, 2:N]

#### Preparing USD data:
setDT(dt0)

dt_USD <- melt(data = dt0, id.vars = "date", measure.vars = colnames(dt0)[2:N])

setDT(dt_USD) 

dt_USD[, base := "USD"]
setnames(dt_USD, "variable", "foreign")
dt_USD[, ticker := with(dt_USD, paste0(base, foreign))] 
setcolorder(dt_USD, c("date", "ticker", "base", "foreign"))

dt_panel <- data.frame(dt_USD)

#### Preparing all other CCY data:
for (i in 2:N) {

dt1 <- data.frame(dt0)
dt1$USD <- 1  
dt1$close_aux <- dt1[,i]  
  
dt1[, 2:(N+2)] <- dt1[, 2:(N+2)] / dt1$close_aux
setDT(dt1)
dt1 <- dt1[, -"close_aux"]

dt2 <- melt(data = dt1, id.vars = "date", measure.vars = colnames(dt1)[2:(N+1)])
setDT(dt2) 
dt2[, base := colnames(dt1)[i] ]
setnames(dt2, "variable", "foreign")
dt2[, ticker := with(dt2, paste0(base, foreign))] 
setcolorder(dt2, c("date", "ticker", "base", "foreign"))

dt2 <- dt2[ foreign != paste(colnames(dt1)[i]) ]

dt_panel <- rbind(dt_panel, dt2)

}
# -----------------------------------------------------------------------------------------


write.table(dt_panel, file = "./output/FX_daily_long.csv", sep = ",")
# -----------------------------------------------------------------------------------------

